/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.serviceagent;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardTaskBean;
import com.ibm.hsc.iw.WizardTaskException;
import com.ibm.hsc.iw.tasks.serviceagent.ServiceAgentConstants;
import com.ibm.hsc.iw.tasks.serviceagent.ServiceAgentEMailInfo;
import com.ibm.hsc.iw.tasks.serviceagent.ServiceAgentEMailInfoChange;
import com.ibm.hsc.iw.tasks.serviceagent.ServiceAgentState;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import java.io.Serializable;
import java.util.ArrayList;

public class NotificationBean
extends WizardTaskBean
implements ServiceAgentConstants {
    private static final String TRACE_MASKD = "JIWZNOBD";
    private static final String TRACE_MASKF = "JIWZNOBF";
    private static final String TRACE_MASKT = "JIWZNOBT";
    private static final int NUM_OF_COLUMNS = 2;
    private static final int EMAIL_ADDR_COLUMN_INDEX = 0;
    private static final int NOTIFICATION_COLUMN_INDEX = 1;
    private String m_sSMTPServer;
    private double m_dPort;
    private ItemDescriptor[][] m_idEMailAddressTable;
    private ColumnDescriptor[] m_cdEMailAddressTableStructure;
    private int[] m_iEMailAddressTableSelection;
    private ServiceAgentState state;

    public NotificationBean(Object object) {
        this.state = (ServiceAgentState)object;
    }

    public void setSMTPServer(String string) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->setSMTPServer(" + string + ")");
        }
        if (string != null) {
            string = string.trim();
        }
        this.m_sSMTPServer = string;
    }

    public String getSMTPServer() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getSMTPServer() returning " + this.m_sSMTPServer);
        }
        return this.m_sSMTPServer;
    }

    public void setPort(double d) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->setPort(" + d + ")");
        }
        if (d != (double)((int)d)) {
            throw new IllegalUserDataException(new LocalizableText("com.ibm.hsc.common.bundles.ServiceAgentText", "PORT_NOT_INTEGER", null).toString());
        }
        this.m_dPort = d;
    }

    public double getPort() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getPort() returning " + this.m_dPort);
        }
        return this.m_dPort;
    }

    public void setEMailAddressTableSelection(int[] nArray) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->setEMailAddressTableSelection(" + nArray + ")");
        }
        this.m_iEMailAddressTableSelection = nArray;
    }

    public int[] getEMailAddressTableSelection() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getEMailAddressTableSelection() returning " + this.m_iEMailAddressTableSelection);
        }
        return this.m_iEMailAddressTableSelection;
    }

    public synchronized void setEMailAddressTableRowAt(int n, ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->setEMailAddressTableRowAt(" + itemDescriptorArray + ")");
        }
        this.m_idEMailAddressTable[n] = itemDescriptorArray;
    }

    public synchronized ItemDescriptor[] getEMailAddressTableRowAt(int n) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getEMailAddressTableRowAt() returning " + this.m_idEMailAddressTable[n]);
        }
        return this.m_idEMailAddressTable[n];
    }

    public synchronized int getEMailAddressTableRowCount() {
        int n = 0;
        if (this.m_idEMailAddressTable != null) {
            n = this.m_idEMailAddressTable.length;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getEMailAddressTableRowCount() returning " + n);
        }
        return n;
    }

    public synchronized int getEMailAddressTableRowStatus() {
        int n = 0;
        n = this.m_idEMailAddressTable == null ? 1 : 3;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getEMailAddressTableRowStatus() returning " + n);
        }
        return n;
    }

    public ColumnDescriptor[] getEMailAddressTableRowStructure() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getEMailAddressTableRowStructure() returning " + this.m_cdEMailAddressTableStructure);
        }
        return this.m_cdEMailAddressTableStructure;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void prepare() {
        if (Trace.LEVEL >= 2) {
            Trace.trace(TRACE_MASKF, "-> prepare()");
        }
        if (Trace.LEVEL >= 2) {
            Trace.trace(TRACE_MASKF, "<- prepare()");
        }
    }

    public void load() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "->load()");
        }
        this.setSMTPServer(this.state.getSMTPServerHostName());
        this.setPort(this.state.getSMTPServerPort());
        this.setTable(this.state.getEMailList());
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<-load()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panelAction(TaskActionEvent taskActionEvent) {
        int[] nArray = null;
        ItemDescriptor[] itemDescriptorArray = null;
        String string = null;
        boolean bl = false;
        String string2 = null;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "->panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + taskActionEvent.getCurrentElement() + "\n\tElementName   : " + taskActionEvent.getElementName() + "\n\tActionCommand : " + taskActionEvent.getActionCommand());
        }
        if (taskActionEvent.getElementName().equals(this.getMountPrefix() + "Button2")) {
            this.display("com.ibm.hsc.iw.tasks.serviceagent.res.ServiceAgent", "Add_email_address", "com.ibm.hsc.iw.tasks.serviceagent.AddAddressBean", null);
        } else if (taskActionEvent.getElementName().equals(this.getMountPrefix() + "Button5")) {
            nArray = this.getEMailAddressTableSelection();
            if (nArray != null && nArray.length == 1) {
                NotificationBean notificationBean = this;
                synchronized (notificationBean) {
                    itemDescriptorArray = this.m_idEMailAddressTable[nArray[0]];
                    string2 = itemDescriptorArray[0].getTitle();
                    string = itemDescriptorArray[1].getTitle();
                }
                bl = string.equals(new LocalizableText("com.ibm.hsc.common.bundles.ServiceAgentText", "ONLY_NOTIFY_OF_CALL_HOME_EVENTS").toString());
                this.display("com.ibm.hsc.iw.tasks.serviceagent.res.ServiceAgent", "Edit_email_address1", "com.ibm.hsc.iw.tasks.serviceagent.EditAddressBean", new ServiceAgentEMailInfo(string2, bl));
            } else if (nArray.length == 0) {
                WizardTaskBean.showNoChoiceMessageBox(this.getUserTaskManager(), new LocalizableText("com.ibm.hsc.common.bundles.ServiceAgentText", "INFO_TITLE", null), new HSCLocalizableMsg(MsgType.INFORMATION_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0007", null));
            } else {
                new AusMicrocodeLog(LOG_INFO, 3).writeEntryFromTaskletClient();
                WizardTaskBean.showNoChoiceMessageBox(this.getUserTaskManager(), new LocalizableText("com.ibm.hsc.common.bundles.ServiceAgentText", "INTERNAL_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0006", null));
            }
        } else if (taskActionEvent.getElementName().equals(this.getMountPrefix() + "Button4")) {
            nArray = this.getEMailAddressTableSelection();
            if (nArray != null && nArray.length == 1) {
                this.deleteInTable(nArray[0]);
                this.reDisplayTable();
            } else if (nArray.length == 0) {
                WizardTaskBean.showNoChoiceMessageBox(this.getUserTaskManager(), new LocalizableText("com.ibm.hsc.common.bundles.ServiceAgentText", "INFO_TITLE", null), new HSCLocalizableMsg(MsgType.INFORMATION_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0007", null));
            } else {
                new AusMicrocodeLog(LOG_INFO, 3).writeEntryFromTaskletClient();
                WizardTaskBean.showNoChoiceMessageBox(this.getUserTaskManager(), new LocalizableText("com.ibm.hsc.common.bundles.ServiceAgentText", "INTERNAL_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0006", null));
            }
        } else {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
            }
            new AusMicrocodeLog(LOG_INFO, 4, new Exception(taskActionEvent.toString())).writeEntryFromTaskletClient();
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<-panelAction(...)");
        }
    }

    public Serializable nextButtonHit() throws WizardTaskException {
        this.state.setSMTPServerHostName(this.getSMTPServer());
        this.state.setSMTPServerPort((int)this.getPort());
        this.state.setEMailList(this.getEMailList());
        return this.state;
    }

    public Serializable backButtonHit() {
        this.state.setSMTPServerHostName(this.getSMTPServer());
        this.state.setSMTPServerPort((int)this.getPort());
        this.state.setEMailList(this.getEMailList());
        return this.state;
    }

    public void displayComplete(Serializable serializable) {
        ServiceAgentEMailInfoChange serviceAgentEMailInfoChange = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->displayComplete(" + serializable + ")");
        }
        serviceAgentEMailInfoChange = (ServiceAgentEMailInfoChange)serializable;
        this.setInTable(serviceAgentEMailInfoChange);
        this.reDisplayTable();
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-displayComplete(...)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTable(ArrayList arrayList) {
        ItemDescriptor[][] itemDescriptorArray = null;
        ItemDescriptor[] itemDescriptorArray2 = null;
        String string = null;
        ServiceAgentEMailInfo serviceAgentEMailInfo = null;
        if (arrayList == null || arrayList.size() == 0) {
            NotificationBean notificationBean = this;
            synchronized (notificationBean) {
                this.m_idEMailAddressTable = new ItemDescriptor[0][0];
            }
        }
        itemDescriptorArray = new ItemDescriptor[arrayList.size()][2];
        for (int i = 0; i < arrayList.size(); ++i) {
            serviceAgentEMailInfo = (ServiceAgentEMailInfo)arrayList.get(i);
            itemDescriptorArray2 = new ItemDescriptor[2];
            itemDescriptorArray2[0] = new ItemDescriptor("SA_Customer_Notification.[" + i + "][" + 0 + "]", serviceAgentEMailInfo.getEMailAddr());
            string = serviceAgentEMailInfo.getOnlyNotifyOfCallHomeEvents() ? "ONLY_NOTIFY_OF_CALL_HOME_EVENTS" : "NOTIFY_OF_ALL_CALL_HOME_EVENTS";
            itemDescriptorArray2[1] = new ItemDescriptor("SA_Customer_Notification.[" + i + "][" + 1 + "]", new LocalizableText("com.ibm.hsc.common.bundles.ServiceAgentText", string, null).toString());
            itemDescriptorArray[i] = itemDescriptorArray2;
        }
        NotificationBean notificationBean = this;
        synchronized (notificationBean) {
            this.m_idEMailAddressTable = itemDescriptorArray;
        }
        this.m_cdEMailAddressTableStructure = new ColumnDescriptor[0];
        this.m_iEMailAddressTableSelection = new int[0];
    }

    private synchronized ArrayList getEMailList() {
        ArrayList<ServiceAgentEMailInfo> arrayList = null;
        ItemDescriptor[] itemDescriptorArray = null;
        String string = null;
        String string2 = null;
        boolean bl = false;
        if (this.m_idEMailAddressTable != null) {
            arrayList = new ArrayList<ServiceAgentEMailInfo>();
            for (int i = 0; i < this.m_idEMailAddressTable.length; ++i) {
                itemDescriptorArray = this.m_idEMailAddressTable[i];
                string = itemDescriptorArray[0].getTitle();
                string2 = itemDescriptorArray[1].getTitle();
                bl = string2.equals(new LocalizableText("com.ibm.hsc.common.bundles.ServiceAgentText", "ONLY_NOTIFY_OF_CALL_HOME_EVENTS").toString());
                arrayList.add(new ServiceAgentEMailInfo(string, bl));
            }
        }
        return arrayList;
    }

    private void setInTable(ServiceAgentEMailInfoChange serviceAgentEMailInfoChange) {
        ArrayList<ServiceAgentEMailInfo> arrayList = null;
        boolean bl = false;
        ServiceAgentEMailInfo serviceAgentEMailInfo = null;
        ServiceAgentEMailInfo serviceAgentEMailInfo2 = null;
        String string = null;
        if (serviceAgentEMailInfoChange != null) {
            serviceAgentEMailInfo = serviceAgentEMailInfoChange.getOriginalInfo();
            if (serviceAgentEMailInfo != null) {
                string = serviceAgentEMailInfo.getEMailAddr();
            }
            arrayList = this.getEMailList();
            bl = false;
            if (string != null && arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    serviceAgentEMailInfo2 = (ServiceAgentEMailInfo)arrayList.get(i);
                    if (!serviceAgentEMailInfo2.getEMailAddr().equals(string)) continue;
                    arrayList.set(i, serviceAgentEMailInfoChange.getCurrentInfo());
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                if (arrayList == null) {
                    arrayList = new ArrayList<ServiceAgentEMailInfo>();
                }
                arrayList.add(serviceAgentEMailInfoChange.getCurrentInfo());
            }
            this.setTable(arrayList);
        }
    }

    private synchronized void deleteInTable(int n) {
        ItemDescriptor[][] itemDescriptorArray = null;
        if (this.m_idEMailAddressTable != null && n < this.m_idEMailAddressTable.length) {
            itemDescriptorArray = new ItemDescriptor[this.m_idEMailAddressTable.length - 1][];
            int n2 = 0;
            for (int i = 0; i < this.m_idEMailAddressTable.length; ++i) {
                if (i == n) continue;
                itemDescriptorArray[n2++] = this.m_idEMailAddressTable[i];
            }
            this.m_idEMailAddressTable = itemDescriptorArray;
        }
    }

    private void reDisplayTable() {
        UserTaskManager userTaskManager = null;
        userTaskManager = this.getUserTaskManager();
        if (userTaskManager != null) {
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "refreshing while mount prefix is " + this.getMountPrefix());
            }
            userTaskManager.refreshElement(this.getMountPrefix() + "Table1");
        }
    }
}

